using System;
using Server;
using Server.Items;
using Server.Mobiles;
using Xanthos.Interfaces;
using System.Collections;
using System.Collections.Generic;

namespace Xanthos.Evo
{
	//[CorpseName( "a spider corpse" )]
	public class EvoSpider : BaseEvo, IEvoCreature
	{
		private ArrayList m_Guardians;
		public bool m_DeletingSummons;
		public ArrayList Guardians { get { return m_Guardians; } }
		public bool DeletingSummons { get { return m_DeletingSummons; } }

		public override BaseEvoSpec GetEvoSpec()
		{
			return EvoSpiderSpec.Instance;
		}

		public override BaseEvoEgg GetEvoEgg()
		{
			return new EvoSpiderEgg();
		}

		public override bool AddPointsOnDamage { get { return false; } }
		public override bool AddPointsOnMelee { get { return true; } }
		public override Type GetEvoDustType() { return typeof(EvoSpiderDust); }
		public override bool IsScaredOfScaryThings { get { return true; } }
		public override Poison PoisonImmune { get { return (m_Stage < m_FinalStage) ? Poison.Deadly : Poison.Lethal; } }
		public override Poison HitPoison { get { return (m_Stage < m_FinalStage) ? Poison.Regular : Poison.Deadly; } }
		public override bool HasBreath { get { return false; } }

		public override WeaponAbility GetWeaponAbility()
		{
			switch (Utility.Random(3))
			{
				default:
				case 0: return WeaponAbility.DoubleStrike;
				case 1: return WeaponAbility.WhirlwindAttack;
				case 2: return WeaponAbility.ConcussionBlow;
			}
		}

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			base.OnDamage(amount, from, willKill, typ);

			if (from is BaseCreature && ((BaseCreature)from).Controlled != true && !willKill && typ < 1)
			{
				if (m_Guardians.Count < MaxSummons())
					Summon(from);
			}
		}

		public int MaxSummons()
		{
			switch (m_Stage)
			{
				case 0: return 1; break;
				case 1: return 2; break;
				case 2: return 3; break;
				case 3: return 4; break;
				case 4: return 4; break;
				case 5: return 5; break;
				case 6: return 4; break;
				default: return 2; break;
			}
		}

		public void Summon(Mobile attacker)
		{
			Map map = this.Map;

			if (map == null)
				return;

			BaseSummonedEvoSpider summon = null;

			if (m_Stage < 4)
				summon = new EvoSpiderSum(this);
			else if (m_Stage < 6)
				summon = new EvoSpiderSumHigh(this);
			else
				summon = new EvoSpiderSumHighest(this);

			if (summon == null)
				return;

			bool validLocation = false;
			Point3D loc = this.Location;

			for (int j = 0; !validLocation && j < 10; ++j)
			{
				int x = X + Utility.Random(3) - 1;
				int y = Y + Utility.Random(3) - 1;
				int z = map.GetAverageZ(x, y);

				if (validLocation = map.CanFit(x, y, this.Z, 16, false, false))
					loc = new Point3D(x, y, Z);
				else if (validLocation = map.CanFit(x, y, z, 16, false, false))
					loc = new Point3D(x, y, z);
			}

			summon.Team = this.Team;
			summon.Controlled = true;
			summon.ControlMaster = this;
			summon.MoveToWorld(loc, map);

			if (attacker != null && !attacker.Deleted && attacker.Alive)
			{
				summon.Combatant = attacker;
				summon.ControlOrder = OrderType.Attack;
				summon.ControlTarget = attacker;

				if (attacker is BaseCreature && m_Guardians.Count == MaxSummons())
					((BaseCreature)attacker).Combatant = summon;
			}
			else
			{
				summon.Combatant = null;
				summon.ControlOrder = OrderType.Follow;
				summon.ControlTarget = this;
			}
		}

		public override bool OnBeforeDeath()
		{
			m_DeletingSummons = true;

			foreach (Mobile m in m_Guardians)
			{
				if (m == null || m.Deleted)
					continue;

				m.Delete();
			}

			m_Guardians.Clear();
			m_DeletingSummons = false;

			return base.OnBeforeDeath();
		}

		public override void OnAfterDelete()
		{
			m_DeletingSummons = true;

			foreach (Mobile m in m_Guardians)
			{
				if (m == null || m.Deleted)
					continue;

				m.Delete();
			}

			m_Guardians.Clear();
			m_DeletingSummons = false;

			base.OnAfterDelete();
		}

		public EvoSpider(string name) : base(name, AIType.AI_Melee, 0.01)
		{
			m_Guardians = new ArrayList();
			m_DeletingSummons = false;
		}

		public EvoSpider(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int)0);
			// 			writer.WriteMobileList( m_Guardians, true );
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			// 			m_Guardians = reader.ReadMobileList();
			m_Guardians = new ArrayList();
			m_DeletingSummons = false;
		}
	}
}